%Skewness Feature Extraction of Negative Pulse
% Take two input parameters: 
% 1. directory of speech data 2. directory of feature data
% no return value

function Skewness_Neg(data_dir,fea_dir)
A = dir(data_dir);
leng = length(A);
relp = cell(1,leng-2);


% LP order determined by sampling rate. 
% 8kHz: 10-12  11.025kHz: 13-15  16kHz: 18-20  20kHz: 22-24  44.1kHz 46-48
p = 14;

for du = 3:leng

til = A(du).name;
pf = dir([data_dir '\' til]);
pf1 = pf(3).name;
wa = [data_dir '\' til '\' pf1];
[y, Fs, nbits] = wavread(wa);
fl=floor(Fs/1000*30);
ws=round(Fs/1000*10);

%%Voiced Frame Extraction
ind = utter(y,Fs,nbits);

l=1;

for k=ind
 left = 0;
right =0;

%% linear prediction and residual signal extraction
sg = y((k-1)*ws+1:(k-1)*ws+fl);
t=length(sg);
pre_c = xcorr(sg,'biased');
coe = pre_c(t+1)/pre_c(t);
pre_sg=filter([1,-coe],1,sg);
pre_t=length(pre_sg);
 w=hamming(pre_t);
 win_sg=pre_sg.*w;

c = xcorr(win_sg,'biased');
r = c(t:(t+p));
a = levinson(r,p);
e = filter(a,1,sg);
re1 = e(p:end-p+1);

%% Skewness feature extraction
[lk,am]=findpeaks(re1,'v',30);
if(length(am)>=3)

[sam ID] = sort(am,'ascend');


slk = sort([lk(ID(1)) lk(ID(2)) lk(ID(3))]);



 for nn = slk(2)-1:-1:1
     if(re1(nn)>=0.2*re1(slk(2)))
         left = nn;
         break
     end
    
 end
 
  for nn = slk(2)+1:1:length(re1)
     if(re1(nn)>=0.2*re1(slk(2)))
         right = nn;
         break
     end
 
  end

  relp{du-2}(l) = (right-slk(2))/(slk(2)-left);
  l=l+1;
end
end


%% store feature estimations
mkdir([fea_dir '\' til]);

fil = ([fea_dir '\' til '\re_fea.txt']);
fid=fopen(fil,'a');

for nnn =1:length(relp{du-2})
fprintf(fid,'%f\n',relp{du-2}(nnn));
end
fclose(fid);

end