// pitchtracker.cpp : Defines the entry point for the console application.
//


#include "yin.h"
#include "wav_in.h"
#include "wav_out.h"
#include "VE_ZCR.h"
#include "OutDet.h"
#include "errno.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include "errno.h"

#include "MathLib.h"



using namespace std;

int GetNumofUtterances(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNUtterances=0;
DIR * dir1;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						
						
						while(ptr1 = readdir(dir1)) 
						{
							
							int d_len = strlen(ptr1->d_name);
							
								if(!(strcmp(&(ptr1->d_name[d_len-3]),"w")) && !(strcmp(&(ptr1->d_name[d_len-2]),"a")) && !(strcmp(&(ptr1->d_name[d_len-1]),"v")))
								{
						   
                       nNUtterances++;
							}
						}
					   closedir(dir1);

	return nNUtterances;
}

int GetNumofSpeakers(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNSpeakers=0;
DIR * dir1;
unsigned char isFolder = 0x4;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						
						while(ptr1 = readdir(dir1)) 
						{
							

							//if(ptr1->d_type == isFolder && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
								if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							
							{
								
                       nNSpeakers++;
							}
							
						   
						}
					   closedir(dir1);

	return nNSpeakers;
}

void GetNamesAndUttNum(string strDataDir, string * pstrNames, int	 * nUtterances)
{
	//Get name and number of utterances of each speaker
                       DIR * dir1;
                        struct dirent * ptr1;
						int i = 0;
						unsigned char isFolder = 0x4;
                        dir1 = opendir(strDataDir.c_str());
						
						while(ptr1 = readdir(dir1)) 
						{
							//if(ptr1->d_type == isFolder && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
								if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							{
								
								string pathname = strDataDir + ("//") + ptr1->d_name;
								nUtterances[i] = GetNumofUtterances(pathname);
								
								pstrNames[i++] = ptr1->d_name;
								
					   }
						}
					   closedir(dir1);
}

int main(int argc, char* argv[])
{
	int nRetCode = 0;
	
	/*if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}*/
	//else
	//{
		//FILE *MyOut;
		FILE *MyOut;
		FILE *MyOut1;
		string strFilename;
		string strFilename1;
        string strPMname;
		// TODO: code your application's behavior here.
		if (argc<2)
		{
			cout<<"Not Enough! Please Input 2 Parameters"<<endl;
			exit(nRetCode);
		}
		string strDataDir(argv[1]);
		string strFeaDir(argv[2]);

		/* Count number of speakers and record their names */

cout<<"Counting number of speakers and recording their names"<<endl;

		int nNSpeakers=0;		//used to record number of speakers
		string * pstrNames;		//record names of speakers (name of directory)
		
		int	 * nUtterances;	//record number of utterances of each speaker
		
		nNSpeakers = GetNumofSpeakers(strDataDir);
		
cout<<nNSpeakers<<endl;
		pstrNames = new string [nNSpeakers];	//allocate memory for names
		

		nUtterances = new int [nNSpeakers];	//allocate memory for number of utterances

		GetNamesAndUttNum(strDataDir,pstrNames,nUtterances);		

		/************************************************************************/
		/* Read wave files and do pitchextraction, save to folder strFeaDir*/

cout<<"Creating Directories for Pitch Extraction"<<endl;
		
int bDoOnce = 1;
		if (bDoOnce)
		{
			//if (GetFileAttributes(strProcDir) == -1)	//folder does not exist
			
				if (mkdir(strFeaDir.c_str(),0777))
				{
					if (errno == EEXIST)
					{
						cout<<"Creating directory "<<strFeaDir<<" failed! Path already exists!"<<endl;
						exit(-1);
					}

					if (errno == ENOENT)
					{
						cout<<"Creating directory "<<strFeaDir<<" failed! Path not found!"<<endl;
						exit(-1);
					}
				}

				strPMname = strFeaDir + ("//") + ("Pitch_Mean.txt");
				double tem;
				double mu = 0;
				double var = 0;
				int leng;

				//double prob[3005]; 
				
				for (int i=0; i<nNSpeakers; i++)
				{	//for each training speaker
					
					if (mkdir((strFeaDir +  ("//") + pstrNames[i]).c_str(),0777))
					{
						if (errno == EEXIST)
						{
							cout<<"Creating directory "<<pstrNames[i]<<" failed! Speaker with same name already exists!"<<endl;
							exit(-1);
						}
					}
					//else
						//successfully created a folder for each speaker
					//cout<<pstrNames[i]<<endl;
						//string strDesDir = strProcDir + ("//") + pstrNames[i] + ("//");
cout<<"Pitch Extraction for "<<pstrNames[i]<<endl;

					strFilename1 = strFeaDir + ("//") + pstrNames[i] + ("//") + ("Raw_Pitch.txt");
                    strFilename = strFeaDir + ("//") + pstrNames[i] + ("//") + ("Pitch.txt");
					leng = 0;
						DIR * dir;
                        struct dirent * ptr;
                      
                        dir = opendir((strDataDir + ("//") + pstrNames[i]).c_str());
						
						
						while(ptr = readdir(dir)) {
							
							
							
							if((strcmp(ptr->d_name,".")) && (strcmp(ptr->d_name,"..")))
							{
								int d_len = strlen(ptr->d_name);
								
								
								if(!(strcmp(&(ptr->d_name[d_len-3]),"wav"))) 
						   {
                      
						   string strSrcFile = strDataDir + ("//") + pstrNames[i] + ("//") + ptr->d_name;
					   
    
							//MyPreProcess(strSrcFile, strDesDir, ptr->d_name,0.97,Thresh,nCep, nFRate, fWLen);
                int FILE_SIZE = strSrcFile.length();
	char * myfn = (char *)malloc((FILE_SIZE+1)*sizeof(char));          
	
	strcpy(myfn,strSrcFile.c_str());
	
	WAV_IN infile(myfn);
	
	double sampleRate = infile.get_sample_rate_hz();
	unsigned int bitsPerSample = infile.get_bits_per_sample();
	unsigned int channels = infile.get_num_channels();
	int nSamples = infile.get_num_samples();

	short * pData = new short [nSamples];	//for storing .wav data
	

	//int nWLen = int(fWLen*sampleRate);	//window length in samples
	int nWlen=(int)(sampleRate*25/1000);                     //window length in samples
	//int nFrameShift = int(sampleRate/nFRate+0.5);	//shift between two consecutive frames
    int nFrameShift=(int)(sampleRate*10/1000);   //shift between two consecutive frames
	
	if (channels != 1)
	{
		cout<<"Only support 1 channel wave right now."<<endl;
		exit(0);
	}

	//double maxData = 0;
	for (int i=0; i<nSamples; i++)
	{
		//read data and search for the maximum
		pData[i] = (short)infile.read_current_input();
		/*double tem = abs(pData[i]);
		if ( tem > maxData)
		{
			maxData = tem;
		}*/
	}
	

	//double NormConst = pow(double(2),double(bitsPerSample-1)) * 0.97/maxData;
	
	//double NormConst = 1/maxData;
	
	/*for (int i=0; i<nSamples; i++)
	{
		//normalize the data according to the maximum
		pData[i] *= NormConst;
		//outfile.write_current_output(pData[i]);
	}  */

	if ( infile.more_data_available())
	{
		cout<<"More than nSamples("<<nSamples<<") samples available"<<endl;
	}

	free(myfn);

int nFrames = (nSamples - nWlen )/nFrameShift + 1;	//int/int === int (float(int)/int
//int VowelFrame=int(nFrames*0.4);
 uint16 period, bestdiff;

yin_t * pit;
pit = 
 yin_init(nWlen, 0.1,
          0.2, 2);
yin_start(pit);

//int * Vowel=VowelExt_ZCR(pData,bitsPerSample,nWlen,nFrameShift,nFrames,nSamples,VowelFrame);
double *pitch = new double[nFrames]; 
double *prob = new double[nFrames]; 
for (int m=0;m<nFrames;m++)
{
pitch[m] = 0.0;
}

for (int m=0;m<nFrames;m++)
{
prob[m] = 0.0;
}
for (int k=0;k<nFrames;k++)
{
	short *Data = new short [nWlen];
	for (int i=0;i<nWlen;i++)
	{
    Data[i] = pData[k*nFrameShift+i];
}
yin_write(pit,Data);
if(yin_read(pit,&period,&bestdiff))
{

pitch[k] = log((period==0) ? sampleRate : (double)sampleRate/period);
prob[k] = (bestdiff > 32768) ? 0.0 : 1.0 - (double)bestdiff / 32768;
}
delete []Data;
}
delete[]pData;


	 if (pit)
	 { yin_free(pit);}



if((MyOut = fopen(strFilename1.c_str(), "a")) == NULL)
{
						   cout<<"Open file"<<strFilename1<<" failed!"<<endl;
						   exit(-1);
						   }
			//fprintf_s(MyOut,"Number of training samples = %d\n",NTRAIN);
			
for (int m=0;m<nFrames;m++)
{
//if(pitch[m] > log(double(50)) && pitch[m] < log(double(1100)) && prob[m]>=0.9)
//if(pitch[m] > 0 && prob[m]>=0.8)
//{
	fprintf(MyOut,"%f\t",prob[m]);
	fprintf(MyOut,"%f\r\n",pitch[m]);
	leng++;
//}
}
fclose(MyOut);

delete[]pitch;
delete[]prob;

}
						   }
							}						
					   closedir(dir);
					  

					   mu = 0;
					  //cout<<leng<<endl;
					   
					   if((MyOut = fopen(strFilename1.c_str(), "r")) == NULL)
					   
					   {
						   cout<<"Open file"<<strFilename1<<" failed!"<<endl;
						   exit(-1);
						   }

					   //fseek( MyOut, 0, SEEK_SET );
					   float * pp = new float [leng];
					   

fseek(MyOut,0L,SEEK_SET);
					   for (int m=0;m<leng;m++)
					   {
						   
					   fscanf(MyOut,"%f",&pp[m]);
					   
					   
					  
					   mu += pp[m];
			}
					    
			mu = mu/leng;
var = 0;
 for (int m=0;m<leng;m++)
					   {
					   var = var + pow(pp[m]-mu,float(2));
			}
					   var = var/leng;
					  
			
			/*while (fscanf(MyOut,"%f,",&tem) != EOF)
			{
				l++;
				mu = mu+tem;
			}
			mu = mu/l;
			cout<<mu<<endl;*/

			

/*fseek( MyOut, 0L, SEEK_SET );
			int le = 0;
			while (fscanf(MyOut,"%f",&tem) != EOF)
			{
				pp[le] = tem;
				cout<<pp[le]<<endl;
				le++;
				var = var + pow(tem-mu,double(2));
			}*/
			fclose(MyOut);
			
			//var = var/l;

int *Dec =  OutDet((double*)pp,leng,(double)mu,(double)var);
mu = 0;
for (int k=0;k<leng;k++)
{
if(Dec[k]==2)
{
pp[k] = pp[k] - log(float(2));
}
if(Dec[k]==3)
{
pp[k] = pp[k] + log(float(2));
}

mu += exp(pp[k]);


if((MyOut1 = fopen(strFilename.c_str(), "a")) == NULL)

{
	
						   cout<<"Open file"<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
//fprintf(MyOut1,"%f\t",prob[k]);
fprintf(MyOut1,"%f\r\n",exp(pp[k]));
fclose(MyOut1);
}
delete[]Dec;
delete[]pp;

//delete[]prob;
//mu = exp(mu/leng);
mu = mu/leng;

if((MyOut1 = fopen(strPMname.c_str(), "a")) == NULL)
{
						   cout<<"Open file"<<strPMname<<" failed!"<<endl;
						   exit(-1);
						   }
fprintf(MyOut1,"%f\r\n",mu);
fclose(MyOut1);
					
				}
			
		}
		/************************************************************************/
delete[]pstrNames;
delete[]nUtterances;
cout<<"Pitch Extraction is Done for all Speakers"<<endl;
return nRetCode;
//}

}
