// Test.cpp : Defines the entry point for the console application.
//


#include "MFCCTest.h"
#include <vector>
#include <algorithm>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
#include "errno.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string>
#include "MathLib.h"
#include "gmr.h"
#include "wav_in.h"
#include "wav_out.h"

#define MYRANK 1

// The one and only application object

//CWinApp theApp;

using namespace std;

/************************************************************************/
/* Class and operators defined for sorting using STL */
class MyScore
{
public:
	string strSpeaker;
	float fScore;
	MyScore() : strSpeaker(""), fScore(0) {}
	MyScore(string speaker, float score) : strSpeaker(speaker), fScore(score) {}
protected:
private:
};

bool operator==(const MyScore& x, const MyScore& y)
{
	return x.fScore == y.fScore;
}
bool operator<(const MyScore& x, const MyScore& y)
{
	return x.fScore < y.fScore;
}

typedef vector<MyScore> MYVECTOR;
/************************************************************************/


inline void endian_swap(unsigned int& x)
{
	x = (x>>24) | 
		((x<<8) & 0x00FF0000) |
		((x>>8) & 0x0000FF00) |
		(x<<24);
}



int GetNumofUtterances(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNUtterances=0;
DIR * dir1;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						
						
						while(ptr1 = readdir(dir1)) 
						{
							
							int d_len = strlen(ptr1->d_name);
							
							
								if(!(strcmp(&(ptr1->d_name[d_len-3]),"w")) && !(strcmp(&(ptr1->d_name[d_len-2]),"a")) && !(strcmp(&(ptr1->d_name[d_len-1]),"v")))
								{
						   
                       nNUtterances++;
							}
						}
					   closedir(dir1);

	return nNUtterances;
}

int GetNumofSpeakers(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNSpeakers=0;
DIR * dir1;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						while(ptr1 = readdir(dir1)) 
						{
							//if(ptr1->d_type == 4 && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
								if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							
							{
								
                       nNSpeakers++;
							}
							
						   
						}
					   closedir(dir1);

	return nNSpeakers;
}

void GetNamesAndUttNum(string strDataDir, string * pstrNames, int	 * nUtterances)
{
	//Get name and number of utterances of each speaker
                       DIR * dir1;
                        struct dirent * ptr1;
						int i = 0;
                        dir1 = opendir(strDataDir.c_str());
						
						while(ptr1 = readdir(dir1)) 
						{
							//if(ptr1->d_type == 4 && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
								if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							{
								
								string pathname = strDataDir + ("//") + ptr1->d_name;
								nUtterances[i] = GetNumofUtterances(pathname);
								
								pstrNames[i++] = ptr1->d_name;
					   }
						}
					   closedir(dir1);
}



int MyPreProcess(string strSrcFile, string strDesDir, string strFileTitle, float fNormal, float fThresh, int nCep, int nFRate, float fWLen)
{
	//Pre-Process: normalization, silence mark
	//nCep:	number of MFCCs
	//nFRate:	 frame rate (frames/sec)
	//fWlen:	window length in seconds
	int FILESIZE = strSrcFile.length();
	char * myfn = (char *)malloc((FILESIZE+1)*sizeof(char));
	
	strcpy(myfn,strSrcFile.c_str());

	WAV_IN infile(myfn);

free(myfn);

	
    //char * myfn;
	
	//strcpy(myfn,strSrcFile.c_str());
	
	
	
	double sampleRate = infile.get_sample_rate_hz();
	unsigned int bitsPerSample = infile.get_bits_per_sample();
	unsigned int channels = infile.get_num_channels();
	int nSamples = infile.get_num_samples();

	

	double * pData = new double [nSamples];	//for storing .wav data

	int nWLen = int(fWLen*sampleRate);	//window length in samples
	int nFrameShift = int(sampleRate/nFRate+0.5);	//shift between two consecutive frames

	if (channels != 1)
	{
		cout<<"Only support 1 channel wave right now."<<endl;
		exit(-1);
	}

	double maxData = 0;
	for (int i=0; i<nSamples; i++)
	{
		//read data and search for the maximum
		pData[i] = infile.read_current_input();
		double tem = fabs(pData[i]);
		if ( tem > maxData)
		{
			maxData = tem;
		}
	}
	


	if ( infile.more_data_available())
	{
		cout<<"More than nSamples("<<nSamples<<") samples available"<<endl;
	}

	int nFrames = (nSamples - nWLen + 1)/nFrameShift + 1;	//int/int === int (float(int)/int)
	unsigned char * pSilenceMark = new unsigned char [nFrames];

	int myidx = 0;
	double myThresh = fThresh* pow(double(2),double(bitsPerSample-1));
	double dMySaturated = 0.99* pow(double(2),double(bitsPerSample-1));
	int bSaturated = 0;
	
	for (int i=0; i<= nSamples - nWLen; i += nFrameShift, myidx++)
	{
		//calculate the energy of each frame, if it is smaller than fThresh, it is considered silence frame
		//save results in strFilename.mrk file, 1 for silence frame, 0 for speech frame
		//Also, frames with over saturated signals should also be removed.
		double MeanValue = 0;
		bSaturated = 0;
		for (int j=i; j<i+nWLen; j++)
		{
			MeanValue += fabs(pData[j]);
			if (pData[j] > dMySaturated)
			{
				bSaturated = 1;	//contain over saturated signal
			}
		}
		MeanValue /= nWLen;
		if (MeanValue < myThresh || bSaturated == 1)
		{
			pSilenceMark[myidx] = 1;
		}
		else
		{
			pSilenceMark[myidx] = 0;
		}
	}

	FILE *stream;
	int TITLE_SIZE = strFileTitle.length();
		string strFileTitle1 = strFileTitle; 
		strFileTitle1.replace(TITLE_SIZE-3,TITLE_SIZE-1,"mrk");
	string strMarkFile = strDesDir + strFileTitle1;
	

	if((stream = fopen(strMarkFile.c_str(), "w")) != NULL)	//success
	{
		fwrite(pSilenceMark, sizeof(unsigned char), nFrames, stream);
		fclose(stream);
	}

	delete [] pSilenceMark;

	/*WAV_OUT outfile(sampleRate, bitsPerSample, channels);
	
	double NormConst = pow(double(2),double(bitsPerSample-1)) * 0.97/maxData;
	
	//double NormConst = 1;
	for (int i=0; i<nSamples; i++)
	{
		//normalize the data according to the maximum
		pData[i] *= NormConst;
		outfile.write_current_output(pData[i]);
		
	}
	int FILE_SIZE = (strDesDir + strFileTitle).length();
	char * NewFile = (char *)malloc((FILE_SIZE+1)*sizeof(char));
	
	strcpy(NewFile,(strDesDir + strFileTitle).c_str());

	outfile.save_wave_file(NewFile);	//save the normalized wav files

free(NewFile);*/

	delete [] pData;


	/************************************************************************/
	/* Calculate MFCC for the given wav file */
	char * strCmd = (char *)malloc(1000*sizeof(char));
	
	
	//int TITLE_SIZE = strFileTitle.length();
		//string strFileTitle1 = strFileTitle; 
		strFileTitle1.replace(TITLE_SIZE-3,TITLE_SIZE-1,"mfc");


	//int le = sprintf (strCmd,"./wave2feat -mswav yes -srate %f -ncep %d -i %s -o %s", sampleRate, nCep, strSrcFile.c_str(),(strDesDir+strFileTitle1).c_str());
	int le = sprintf (strCmd,"./wave2feat -mswav yes -wlen %f -nfilt %d -lowerf %f -upperf %f -nfft %d -srate %f -ncep %d -i %s -o %s", 0.0232, 31, 200.00000, 3500.0000, 256, sampleRate, nCep, strSrcFile.c_str(),(strDesDir+strFileTitle1).c_str());

	if (!system(NULL))
   {
   cout<<"command processor is not available for MFCC Calculation"<<endl;
   exit(1);
   }
    else
	{
   system(strCmd); 
   }
free(strCmd);
	/************************************************************************/

	return 1;
}

int MFCCTest(string strDataDir, string strProcDir,int nTrainedSpeakers,string * pstrTrainedNames,string pstrNames,float Thresh)
{
	int nRetCode = 0;
	int nCep = 26;		//Number of MFCCs
	int nFRate	= 100;	//frame rate, (frames/second)
	//float fWLen	= 0.025625;	//window length (seconds)
	float fWLen	= 0.0232;	//window length (seconds)

	int bSaveRank = 1;		//indicate save the results into .txt file or not

	// initialize MFC and print and error on failure
	/*if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}*/
	//else
	//{

	/*if (argc<4)
		{
			cout<<"Not Enough! Please Input 4 Parameters"<<endl;
			exit(nRetCode);
		}
		// TODO: code your application's behavior here.
		string strDataDir(argv[1]);	//directory of raw input wav files
		string strProcDir(argv[2]);	//directory of pre-processed wav files and all intermediate files
		string strProcTrainDir(argv[3]);	//directory contains trained _GMM.txt files
		float Thresh = (float)atof(argv[4]);*/
		string strFilename;

		/************************************************************************/
		/* Count number of speakers and record their names */
		int nNSpeakers=0;		//used to record number of speakers
		//string * pstrNames;		//record names of speakers (name of directory)
		
		//int	 * nUtterances;	//record number of utterances of each speaker
		
		//nNSpeakers = 1//GetNumofSpeakers(strDataDir);
		

		//string pstrNames = name;	//allocate memory for names
		

		//nUtterances = new int [nNSpeakers];	//allocate memory for number of utterances

		//GetNamesAndUttNum(strDataDir,pstrNames,nUtterances);		
		
		/************************************************************************/

		/************************************************************************/
		/* Read wave files and do preprocessing, save to folder strProcDir*/
		int bDoOnce = 1;
		if (bDoOnce)
		{
			//if (GetFileAttributes(strProcDir) == -1)	//folder does not exist
			
				/*if (mkdir(strProcDir.c_str(),0777))
				{
					if (errno == EEXIST)
					{
						cout<<"Creating directory "<<strProcDir<<" failed! Path already exists!"<<endl;
						exit(-1);
					}
				}*/
				
				//for (int i=0; i<nNSpeakers; i++)
				//{	//for each training speaker
					
					if (mkdir((strProcDir +  ("//") + pstrNames).c_str(),0777))
					{
						if (errno == EEXIST)
						{
							cout<<"Creating directory "<<pstrNames<<" failed! Speaker with same name already exists!"<<endl;
							exit(-1);
						}
					}
					//else
						//successfully created a folder for each speaker
						string strDesDir = strProcDir + ("//") + pstrNames + ("//");
						DIR * dir;
                        struct dirent * ptr;
                      
                        dir = opendir((strDataDir).c_str());
						
						while(ptr = readdir(dir)) {
							
							
							
							if((strcmp(ptr->d_name,".")) && (strcmp(ptr->d_name,"..")))
							{
								int d_len = strlen(ptr->d_name);
								
								
								if(!(strcmp(&(ptr->d_name[d_len-3]),"wav"))) 
						   {
                       
						   string strSrcFile = strDataDir + ("//") + ptr->d_name;
					   
    
							MyPreProcess(strSrcFile, strDesDir, ptr->d_name,0.97,Thresh,nCep, nFRate, fWLen);
						   }
							}
						}
					   closedir(dir);
					
				//}
			
		}
		/************************************************************************/
		

		/************************************************************************/
		/* Read MFCC from saved .mfc files and save into one txt file*/
		//CFile fileMyFile;
		//CFileException e;
		FILE *MyOut;
		FILE *MyFile;
		FILE *MyFile1;
		string strMsg;
		unsigned int nLen;
		int nFrames;
		//for (int i=0; i<nNSpeakers; i++)
		//{
			/************************************************************************/
			/* Open a _train.txt file to write MFCC values */
			strFilename = pstrNames + ("_test.txt");
			strFilename = strProcDir + ("//") + pstrNames + ("//") + strFilename;
			
			//MyOut = fopen(strFilename.c_str(), "w");
			 if((MyOut = fopen(strFilename.c_str(), "w")) == NULL)
						   {
						   cout<<"Open file "<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
			/************************************************************************/
			char * pBuf;
				float *pfrBuf;
				long int nMarkLen;
				unsigned char * pBuf1;
				

			string strDesDir = strProcDir + ("//") + pstrNames + ("//");
			DIR * dir;
			struct dirent * ptr;
                       dir = opendir((strProcDir+("//")+pstrNames+("//")).c_str());
					   while(ptr = readdir(dir)) 
					   {
						   int d_len = strlen(ptr->d_name);


if(!(strcmp(&(ptr->d_name[d_len-3]),"mrk")))
 {
	 
 string strFilename = strProcDir+("//")+pstrNames+("//")+ptr->d_name;
                          
 if((MyFile1 = fopen(strFilename.c_str(), "r")) == NULL)
						   {
						   cout<<"Open file "<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
 


fseek (MyFile1, 0, SEEK_END);
     

// }
nMarkLen =  ftell (MyFile1);
pBuf1 = new unsigned char [nMarkLen];

fseek (MyFile1, 0, SEEK_SET);
				
				fread(pBuf1,nMarkLen,size_t(1),MyFile1);
				
				fclose(MyFile1);
					  
 
//}

string strMFC = ptr->d_name;
strMFC.replace(d_len-3,d_len-1,"mfc");

						   
						   //if(!(strcmp(&(ptr->d_name[d_len-3]),"mfc")))
								//if(!(strcmp(&(ptr->d_name[d_len-3]),"m")) && !(strcmp(&(ptr->d_name[d_len-2]),"f")) && !(strcmp(&(ptr->d_name[d_len-1]),"c")))
						   //{
                    
						   //string strSrcFile1 = strProcDir+("//")+pstrNames[i]+("//")+ptr->d_name;
						   string strSrcFile1 = strProcDir+("//")+pstrNames+("//")+strMFC;
                           
						 
						   if((MyFile = fopen(strSrcFile1.c_str(), "r")) == NULL)
						   {
						   cout<<"Open file "<<strSrcFile1<<" failed!"<<endl;
						   exit(-1);
						   }
						   

                           fread(&nLen,4,(size_t)1,MyFile);
						  
				           endian_swap(nLen);
						  
						  
				           nFrames = nLen/nCep;
						  
				           pBuf = new char [nLen*4];
				           fread(pBuf,nLen*4,(size_t)1,MyFile);
				           pfrBuf = (float *)pBuf;
				           fclose(MyFile);	
						   
						   
						   
//string strFileTitle = ptr->d_name;
						   /* Read silence marks, 1 for silence frames, 0 otherwise */

				//strFilename = strDesDir + strFileTitle;
				//cout<<strFilename<<endl;

 
								
				/************************************************************************/

				/************************************************************************/
				/* save MFCC to a .txt file */
				for (int frame=0; frame<nFrames; frame++)
				{
					if (frame < nMarkLen && pBuf1[frame] == 0)
					{	//write to file, frame within file range and not a silence frame
						//fprintf_s(MyOut, "%d ",nIndex++);
						for (int cc=0;cc<nCep;cc++)
						{
							fprintf(MyOut,"%f ",pfrBuf[frame*nCep+cc]);
						}
						fprintf(MyOut,"\r\n");
					}
				}
 
				/************************************************************************/
				delete [] pBuf;
				delete [] pBuf1;
								
					   }
					   }
					   
                fclose(MyOut);
                closedir(dir);
		//}
		

		///************************************************************************/


		///************************************************************************/
		///* Count number of speakers and record their names */
		//CFileFind finder;
		//CString strDataDir(argv[1]);
		//CString strWildcard(argv[1]);
		//CString strFilename;
		//int nNSpeakers=0;		//used to record number of speakers
		//CString * pstrNames;		//record names of speakers (name of directory)
		//int	 * nUtterances;	//record number of utterances of each speaker
		//strWildcard   +=   _T("\\*.*");  
		//BOOL bWorking = finder.FindFile(strWildcard);
		//while (bWorking)
		//{
		//	bWorking = finder.FindNextFile();
		//	strFilename = finder.GetFileName();
		//	if (finder.IsDirectory() && strFilename != _T(".") && strFilename != _T(".."))
		//	{
		//		nNSpeakers++;
		//	}
		//}
		//finder.Close();

		//pstrNames = new CString [nNSpeakers];	//allocate memory for names
		////cout<<nNSpeakers;
		//nUtterances = new int [nNSpeakers];	//allocate memory for number of utterances

		//bWorking = finder.FindFile(strWildcard);
		//int i=0;
		//while (bWorking)
		//{
		//	bWorking = finder.FindNextFile();
		//	strFilename = finder.GetFileName();
		//	if (finder.IsDirectory() && strFilename != _T(".") && strFilename != _T(".."))
		//	{
		//		int nUtCount = CountFileExt(strDataDir+_T("\\")+strFilename+_T("\\*.*"), _T(".wav"));
		//		nUtterances[i] = nUtCount;	//count for number of .wav files
		//		pstrNames[i++] = strFilename;
		//	}
		//}
		//finder.Close();

		//for (int i=0; i<nNSpeakers; i++)
		//{
		//	cout<<i<<"   "<<nUtterances[i]<<endl;
		//}

		/************************************************************************/
		//int nCep = 26;

		///************************************************************************/
		///* Read parameters of each speaker */
		//CString strFileTitle;
		//FILE *MyFile;
		//errno_t err;

		//int nState, ntemState;	//number of component in GMM
		//int nDim, ntemDim;		//dimension of data vector
		////Verify if all the speakers are trained with same nDim and nState
		//strFileTitle = strDataDir + _T("\\") + pstrNames[0] + _T("\\");
		//strFilename = strFileTitle + pstrNames[0] + _T("_GMM.txt");
		//if ((err = _tfopen_s(&MyFile, strFilename, _T("r"))) != 0)
		//{
		//	cout<<strFilename<<"open failed!"<<endl;
		//}
		//// Set pointer to beginning of file:
		//fseek( MyFile, 0L, SEEK_SET );
		//fscanf_s(MyFile,"%d",&nDim);
		//fscanf_s(MyFile,"%d",&nState);
		//fclose(MyFile);
		//for (int n=1;n<nNSpeakers;n++ )
		//{
		//	strFileTitle = strDataDir + _T("\\") + pstrNames[n] + _T("\\");
		//	strFilename = strFileTitle + pstrNames[n] + _T("_GMM.txt");
		//	if ((err = _tfopen_s(&MyFile, strFilename, _T("r"))) != 0)
		//	{
		//		cout<<strFilename<<"open failed!"<<endl;
		//	}
		//	// Set pointer to beginning of file:
		//	fseek( MyFile, 0L, SEEK_SET );
		//	fscanf_s(MyFile,"%d",&ntemDim);
		//	fscanf_s(MyFile,"%d",&ntemState);
		//	fclose(MyFile);
		//	if (ntemDim != nDim || ntemState != nState)
		//	{
		//		cout<<"Speakers are trained with different dimension or state."<<endl;
		//		return -1;
		//	}
		//}

		////Allocate memory to store all the parameters for each speaker
		//Matrix prior(nNSpeakers,nState);
		//Matrix *mu = new Matrix [nNSpeakers];
		//Matrix *sigma = new Matrix [nNSpeakers];		//assume all sigma matrix are diagonal, 
		//																									//we only record diagonal elements
		////read parameters
		//float tem;
		//for (int n=0;n<nNSpeakers;n++ )
		//{
		//	mu[n].Resize(nState,nDim,false);
		//	mu[n].Zero();
		//	sigma[n].Resize(nState,nDim,false);
		//	sigma[n].Zero();
		//	strFileTitle = strDataDir + _T("\\") + pstrNames[n] + _T("\\") + pstrNames[n] ;
		//	strFilename = strFileTitle + _T("_GMM.txt");
		//	if ((err = _tfopen_s(&MyFile, strFilename, _T("r"))) != 0)
		//	{
		//		cout<<strFilename<<"open failed!"<<endl;
		//	}
		//	// Set pointer to beginning of file:
		//	fseek( MyFile, 0L, SEEK_SET );
		//	fscanf_s(MyFile,"%d",&ntemDim);
		//	fscanf_s(MyFile,"%d",&ntemState);
		//	for (int s=0;s<nState;s++)	//read priors
		//	{
		//		fscanf_s(MyFile,"%f", &prior(n,s));
		//	}
		//	for (int s=0;s<nState;s++)	//read mu
		//	{
		//		for (int d=0;d<nDim;d++)
		//		{
		//			fscanf_s(MyFile,"%f", &mu[n](s,d));
		//		}
		//	}
		//	for (int s=0;s<nState;s++)	//read sigma
		//	{
		//		for (int d1=0;d1<nDim;d1++)
		//		{
		//			for (int d2=0;d2<nDim;d2++)
		//			{
		//				if (d1 == d2)
		//				{
		//					fscanf_s(MyFile,"%f", &sigma[n](s,d1));	//read diagonal elements
		//				}
		//				else
		//				{
		//					fscanf_s(MyFile,"%f",&tem);	//should be all 0
		//				}
		//			}
		//		}
		//	}
		//	fclose(MyFile);
		//}
		///************************************************************************/

		/************************************************************************/
		/* Test for each speaker */
		//Read trained model parameters from _GMM.txt file
		//Read testing MFCC of utterances from _test.txt file

	
		char *filename;

		float tem;

		//int nTrainedSpeakers = GetNumofSpeakers(strProcTrainDir);

		GaussianMixture *g = new GaussianMixture[nTrainedSpeakers];	//record GMM parameters for each trained speaker
		
		//Matrix *TestData = new Matrix[nNSpeakers];		//record test data for each speaker under test
		//int * pCountFrame = new int[nNSpeakers];		//record number of frames for each speaker under test

		Matrix TestData;		//record test data for each speaker under test
		int pCountFrame;		//record number of frames for each speaker under test

		//string * pstrTrainedNames;		//record names of trained speakers (name of directory)
		//int	 * nTrainedUtterances;	//record number of utterances of each speaker
		//pstrTrainedNames = new string [nTrainedSpeakers];	//allocate memory for names
		//nTrainedUtterances = new int [nTrainedSpeakers];	//allocate memory for number of utterances
		//GetNamesAndUttNum(strProcTrainDir,pstrTrainedNames,nTrainedUtterances);		
		

		for (int n=0; n<nTrainedSpeakers; n++)
		{
			//load trained parameters
			strFilename = pstrTrainedNames[n] + ("_GMM.txt");
			//strFilename = strProcTrainDir + ("//") + pstrTrainedNames[n] + ("//") + strFilename;
			strFilename = ("..//GMM_Train_30s_Test_30s_30dB//Proc_Train_1373//") + pstrTrainedNames[n] + ("//") + strFilename;
            //int FILE_SIZE = sizeof(strFilename.c_str());
			//filename = (char*)malloc(FILE_SIZE);
			//strcpy(filename,strFilename.c_str());
			//cout<<filename<<endl;
			g[n].loadParams(strFilename.c_str());
		}

		//for (int n=0;n<nNSpeakers;n++)
		//{
			//Read testing data to TestData
			strFilename = pstrNames + ("_test.txt");
			strFilename = strProcDir + ("//") + pstrNames + ("//") + strFilename;

                           if((MyFile = fopen(strFilename.c_str(), "r")) == NULL)
						   {
						   cout<<"Open file"<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
						  

			fseek( MyFile, 0L, SEEK_SET );
			int nFileCount = 0;
			while (fscanf(MyFile,"%f",&tem) != EOF)
			{
				nFileCount ++;
			}
			
			pCountFrame = nFileCount/nCep;	//Get number of frames first
			//Read frames for testing
			fseek( MyFile, 0L, SEEK_SET );
			TestData.Resize(pCountFrame,nCep,false);
			TestData.Zero();
			for (int i=0;i<pCountFrame;i++)
			{
				for (int j=0;j<nCep;j++)
				{
					fscanf(MyFile,"%f",&TestData(i,j));
				}
			}
			fclose(MyFile);
		//}


		//Testing
		Matrix scores;
		scores.Resize(nNSpeakers,MYRANK);

		int correct1 = 0;				//number of first match
		//int correct_rank = 0;		//number of matches within RANK
		int nMyEnd = MYRANK;

		if (nTrainedSpeakers < MYRANK)
		{
			nMyEnd = nTrainedSpeakers;
		}

		strFilename = ("Results9.txt");
		//strFilename = strProcDir + ("//") + strFilename;

                           if((MyFile = fopen(strFilename.c_str(), "a")) == NULL)
						   {
						   cout<<"Open file"<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }


		//time_t start,end;
		//	time (&start);

		//for (int n=0;n<nNSpeakers;n++)
		//{
			cout<<"Testing "<<pstrNames<<"..."<<endl;
			MYVECTOR theVector;
			MYVECTOR::iterator theIterator;
			//float * pfProb_Frame = new float [pCountFrame[n]];
			//cout<<nTrainedSpeakers<<endl;
			//cout<<nTrainedSpeakers<<endl;
			for (int t=0;t<nTrainedSpeakers;t++)
			{
			//	cout<<t<<endl;
				long double prob_t = 0.0;
				for (int f=0;f<pCountFrame;f++)
				{
					prob_t += log(g[t].MyGetProb(TestData.GetRow(f)));
				}
				//prob_t = pow(prob_t,(double)1.0/pCountFrame[n]);
				prob_t = prob_t/pCountFrame;
				theVector.push_back(MyScore(pstrTrainedNames[t],prob_t));
			}
			//cout<<"code"<<endl;
			stable_sort(theVector.begin(), theVector.end());	//sort into non descending order
			theIterator = theVector.end();	//this is NULL since value should be [begin end-1]
			if (theVector.size() > 0)
			{
				//cout<<"code1"<<endl;
				theIterator--;
				if (theIterator->strSpeaker == pstrNames)
				{	//first match
					correct1 ++;
				}
				int ret = 0;
				if (bSaveRank == 1)
				{
					fprintf(MyFile,"%s\t", pstrNames.c_str());
				}
				for (int k=0;k<nMyEnd;k++)
				{
					//cout<<"code2"<<endl;
					if (bSaveRank == 1)
					{	//save Rank results to file
						fprintf(MyFile,"%s\r\n", theIterator->strSpeaker.c_str());
					}
					if (theIterator->strSpeaker == pstrNames)
					{	//any of the first RANK matches is correct
						ret =1;
					}
					if (theIterator != theVector.begin())
					{
						theIterator--;
					}
					else
					{
						break;
					}
				}
				//if (ret == 1)
				//{
				//	correct_rank ++;
				//}
				/*if (bSaveRank == 1)
				{
					fprintf(MyFile,"\n");
				}*/
			}
		//}
		fclose(MyFile);

		//time (&end);
        //double dwDuration = difftime (end,start);
		//fprintf(MyFile,"(took %f seconds)\n",dwDuration);
		//fclose(MyFile);
        
		/*strFilename = ("Correct.txt");
		strFilename = strProcDir + ("//") + strFilename;

 if((MyFile = fopen(strFilename.c_str(), "w")) == NULL)
						   {
						   cout<<"Open file"<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }

		fprintf(MyFile,"%d",correct1);
		fclose(MyFile);*/
		//fprintf_s(MyFile,"Correct recognitions of rank %d = %d\n",MYRANK,correct_rank);
		//strFilename = _T("Time.txt");
		//strFilename = strProcDir + _T("\\") + strFilename;
		//if ((err = _tfopen_s(&MyFile, strFilename, _T("w"))) != 0)
		//{
		//	cout<<strFilename<<"open failed!"<<endl;
		//}
		//fprintf_s(MyFile,"%f",((float)dwDuration)/1000);
		//	fclose(MyFile);
		
		//for (int n=0; n<nNSpeakers;n++)
		//{
		//	strFileTitle = strDataDir + _T("\\") + pstrNames[n] + _T("\\") + pstrNames[n] ;
		//	strFilename = strFileTitle + _T("_test.txt");
		//	if ((err = _tfopen_s(&MyFile, strFilename, _T("r"))) != 0)
		//	{
		//		cout<<strFilename<<"open failed!"<<endl;
		//	}
		//	fseek( MyFile, 0L, SEEK_SET );
		//	int nFileCount = 0;
		//	while (fscanf_s(MyFile,"%f",&tem) != EOF)
		//	{
		//		nFileCount ++;
		//	}
		//	int nCountFrame = nFileCount/nCep;	//Get number of frames first
		//	//Read frames for testing
		//	fseek( MyFile, 0L, SEEK_SET );
		//	Matrix TestData;
		//	TestData.Resize(nCountFrame,nCep,false);
		//	TestData.Zero();
		//	for (int i=0;i<nCountFrame;i++)
		//	{
		//		for (int j=0;j<nCep;j++)
		//		{
		//			fscanf_s(MyFile,"%f",&TestData(i,j));
		//		}
		//	}
		//	fclose(MyFile);

		//	for (int t=0; t<nNSpeakers; t++)
		//	{
		//		float *prob = new float [nCountFrame];	//calculate prob of each frame
		//		for (int f=0;f<nCountFrame;f++)
		//		{
		//			float fProb = 0.0;
		//			for (int s=0;s<nState;s++)
		//			{
		//				//calculate prob
		//			}
		//		}
		//	}
		//}
		/************************************************************************/
	//}
//delete[]pstrNames;
//delete[]nUtterances;
delete[]g;
//delete[]TestData;
//delete[]pCountFrame;
//delete[]pstrTrainedNames;
//delete[]nTrainedUtterances;
	return nRetCode;
}
