function [dctN, shift_matrix, inv_shift_matrix] = shift(bl_mask,N)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function shift an irregular shape to left top of a N size square 
%
%
% INPUT ARGUMENT
% N: size of block
% bl_mask: block mask

% OUTPUT ARGUMENT:
% dctN: length of column in shifted block
% shift_matrix: each entry shows its index in a shifted block
% inv_shift_matrix: each entry shows its index in a inverse shifted block
%

% nonzero entry index
[entry_r, entry_c] = find(bl_mask);
entry = [entry_r, entry_c];
shift_matrix = cell(N,N);
inv_shift_matrix = cell(N,N);
shifted_mask = zeros(N);

k = 1;
for i=min(entry_c):max(entry_c)
    % ensure this is nonzero column
    if size(find(entry_c==i))~=0
       col_idx = find(entry(:,2)==i);
       % number of coefficient in one column
       dctN(1,k) = size(col_idx,1);
       % shift 
        % if column doesn't match, shift both column & row
       if entry(col_idx(1),1)~=1
          for j=1:size(col_idx,1)
              shift_matrix{entry(col_idx(j),1),i} = [entry(col_idx(j),1)-entry(col_idx(1),1)+1,k];
              shifted_mask(entry(col_idx(j),1)-entry(col_idx(1),1)+1,k) = bl_mask(entry(col_idx(j),1),i);
              inv_shift_matrix{entry(col_idx(j),1)-entry(col_idx(1),1)+1,k} = [entry(col_idx(j),1),i];
          end
       else
           % otherwise shift row only
          for j=1:size(col_idx,1)
              shift_matrix{entry(col_idx(j),1),i} = [entry(col_idx(j),1),k];
              shifted_mask(entry(col_idx(j),1),k) = bl_mask(entry(col_idx(j),1),i);
              inv_shift_matrix{entry(col_idx(j),1),k} = [entry(col_idx(j),1),i];
          end
       end
     k = k+1;  
    end
end

for i=1:N
    n = size(find(shifted_mask(i,:)),2);
    if n~=0
        dctN(2,i) = n;
    else
        break;
    end
end

