function weight_sx = sa_bl_weight(Wsx,sigma,inv_mean,nonzero_num,Wwin2D_wiener)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function calculates block weight for shape adaptive block
%
% INPUT ARGUMENT:
% Wsx: weight of SA-DCT coefficient for noise image
% sigma: s.d. of noise
% inv_mean: weight of subtracted mean of SA-DCT
% nonzero_num: # of nonzero coefficient in iregular shaped block
%
%
% OUTPUT ARGUMENT:
% weight_sx: weight for iregular shaped block
%
%
Wsx = Wsx.^2;
for i=1:size(Wsx,3)
    denom = (sum(sum(Wsx(:,:,i)))+inv_mean(i)^2)*nonzero_num;
    weight(i) = 1/(sigma^2*denom);
    weight_sx(:,:,i) = weight(i).*Wwin2D_wiener;
end
