function Esx = irg_blm(x,y,Ns,N2,N1,mask_bl,k,tau_match_wiener,m,n,HT_img)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function does Block Matching for irregular shaped block, find a
%%%% block stack that resembles current block by normalized L2-norm rule
%
%
%
% INPUT ARGUMENTS:
% 1)x,y (integer): coordinates of left-top pixel of the block
% 2)Ns (integer): block matching search range centered at (x,y), odd num
% 3)N2 (integer): maximum # blocks in stack
% 4)N1 (integer): block size
% 5)mask_bl (binary matrix N1xN1): mask block of object k,
% obj_part=1,otherwise=0
% 6)k (integer): object number correspond to mask_bl;
% 7)tau_match_wiener (double): block matching threshold
% 8)m,n (integer): image size
% 9)HT_img (matrix MxN): initial image estimation 
%
% OUT ARGUMENT
% Esx (match bl coordinate (xi,yi)): block stack coordinates
% after block matching
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Step 1: bound search range in NsxNs
x1 = x-(Ns-1)/2;
x2 = x+(Ns-1)/2;

y1 = y- (Ns-1)/2;
y2 = y+ (Ns-1)/2;

%(xt,yt) and (xb,yb) is top-left and bottom right of search range
if x1<=0
    xt = 1;
else
    xt = x1;
end

if x2>m
    xb = m;
else
    xb = x2;
end

if y1<=0
    yt = 1;
else
    yt = y1;
end

if y2>n
    yb = n;
else
    yb = y2;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Step 2: full search to find N match block
% If N>N2, select first N2 blocks with smallest d
% Normalized L2-norm rule: 1/N_obj^2|(Esx-e(Esx))-(Ex-e(Ex))|2

%tau_match varies on object (the number of pixels in object)
Nk = size(find(mask_bl),1);
tau_match_wiener = tau_match_wiener*(Nk/N1^2);

Esx(1,1) = x;
Esx(1,2) = y;
Esx(1,3) = 0;

id = 1;
mask_bl,
HT_img(x:x+N1-1,y:y+N1-1)
curr_bl = HT_img(x:x+N1-1,y:y+N1-1).*mask_bl;
e_sx = mean(mean(curr_bl))*(Nk/N1^2); %mean value is calculated only for non-zero pixels
curr_bl = (curr_bl-e_sx).*mask_bl;

for i=0:xb-(N1-1)-xt
    for j=0:yb-(N1-1)-yt
        if (xt+i==x)&&(yt+j==y)
            continue;
        else
            s_bl = HT_img(xt+i:xt+i+N1-1,yt+j:yt+j+N1-1).*mask_bl;
            e_x = mean(mean(s_bl))*(Nk/N1^2);%mean value is calculated only for non-zero pixels
            s_bl = (s_bl-e_x).*mask_bl;
            err = mean((curr_bl(:)-s_bl(:)).^2)*(N1^2/Nk);
        
            if err<tau_match_wiener
               id = id+1;
               Esx(id,1)=xt+i;
               Esx(id,2)=yt+j;
               Esx(id,3)=err;
            end
        end
        
    end
end

%reorder so that error ascends
Esx = sortrows(Esx,3);

if id>N2
    %select the first N2 of smallest error  
    Esx = Esx(1:N2,1:2);
     % force 3rd dimension is a power of 2 for 1D haar transform
else if id~= 2^(floor(log2(id)))
        id = 2^(floor(log2(id)));
        Esx = Esx(1:id,1:2);
    end
end




