function trans_Y = inv_3d_trans(trans_Y, TinvW, hadper_trans_single_den, N1,mask_bl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function operate inverse 3D transform to transformed 3D block
%%% stack, inverse 3D transform is seperable composition of 2D+1D
%
%
%
%
% INPUT ARGUMENT:
% 1)trans_Y (3D matrix): transformed block stack
% 2)TinvW: inverse transform matrix
% 3)hadper_trans_single_den: indicator if Haar is used
% 4)N1: block size
%
% OUTPUT ARGUMENT:
% Y (3D matrix): inverse transform block stack
%
%
%
if isempty(hadper_trans_single_den)==1

    l = size(trans_Y);
    if size(l,2)<3
        trans_Y(:,:,1) = trans_Y;
        l(3) = 1;
    end
    %inverse Haar transform in 3rd
   if l(3)>1
    for i=1:N1
        for j=1:N1
        % size(trans_Y)
         trans_Y(i,j,:) = idwt(trans_Y(i,j,1:l(3)/2),trans_Y(i,j,(l(3)/2+1):l(3)),'haar');         
        end
    %end
    end
   end
end

% 2D inverse transform
for k=1:l(3)
    trans_Y(:,:,k) = TinvW*trans_Y(:,:,k)*TinvW';
    if isempty(mask_bl)~=1
       trans_Y(:,:,k) = trans_Y(:,:,k).*mask_bl;
    end
end


