function ebuff(Ysx, weight_sx, Esx, N1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function is to aggregate the block stack estimation into
%%% estimation buffer, which is a global variable
%
%
%
% INPUT ARGUMENTS:
% 1)Ysx (3D matrix): wiener estimation of block stack
% 2)weight_sx (N1xN1 matrix): weighting window for the block stack
% 3)Esx: (x,y) coordinates of matched block in block stack
% 4)N1: block size
%
%
%
%
global e_buff;


N = size(Esx,1);

% if isempty(bl_mask)~=1
%    % Weighting block stack 
%    for k=1:N
%        Ysx(:,:,k) = weight_sx(:,:,k).*Ysx(:,:,k).*bl_mask;
%    end
% else
   for k=1:N
       Ysx(:,:,k) = weight_sx.*Ysx(:,:,k);
   end
% end
    


% aggregate block into global estimation buffer


for t=1:N
    x = Esx(t,1);
    y = Esx(t,2);
    e_buff(x:x+N1-1,y:y+N1-1) = Ysx(:,:,t)+e_buff(x:x+N1-1,y:y+N1-1);
end
