function  d3_blk = d3_trans(Esx, img, TforW, hadper_trans_single_den, N1,mask_bl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function operate 3D transform to 3 dimension block stack, 3D
%%% transform is a seperable composition of 2D+1D
%
%
%
% INPUT ARGUMENTS:
% 1)Esx: (x,y) coordinates of block stack
% 2)img (matrix MxN): image
% 3)TforW: forward transform matrix
% 4)hadper_trans_single_den: indicator if Haar is used
% 5)N1: block size
%
%
%
% OUTPUT ARGUMENT:
% 3d_blk (3D matrix): 3D transform of block stack, same size with Esx
%
%
%
for t=1:size(Esx,1)
    blk = img(Esx(t,1):Esx(t,1)+N1-1,Esx(t,2):Esx(t,2)+N1-1);
    if isempty(mask_bl)~=1
        blk = blk.*mask_bl;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % padding average 
        Nk = size(find(mask_bl),1);
        av_non0 = mean(mean(blk))*(N1^2/Nk);
        [r,c] = find(mask_bl==0);
        for l=1:size(r,1)
            blk(r(l),c(l)) = av_non0;
        end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
    % 2D transform
    d2_blk = TforW*blk*TforW';
    d3_blk(:,:,t) = d2_blk;
end
if t==1
    return;
else
  % 3D Haar transform: full dyadic decomposition of approximation & diff
  if isempty(hadper_trans_single_den)==1
    for i=1:N1
        for j=1:N1
            [app,dff] = dwt(d3_blk(i,j,:),'haar');
            %3rd dimension is [approximation,diff]
            d3_blk(i,j,:)=[app,dff];
        end
    end
  end
end


