function d3_blk = d3_thr_trans(Zsx, N1, nois_img, Tfor, hadper_trans_single_den,mask_bl)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% This function does separable 3D transform the block stack (2D+1D).
%
%
%
% INPUT ARGUMENT:
% Zsx: [(x,y)...] coordinates of block stack
% N1: block size
% nois_img: noisy image
% Tfor: 2D forward transform matrix
% hadper_trans_single_den: indicate if Haar is used in 3rd
%
%
% OUTPUT ARGUMENT:
% T_Zsx: 3D transform of block stack
%
%
for t=1:size(Zsx,1)
    blk = nois_img(Zsx(t,1):Zsx(t,1)+N1-1,Zsx(t,2):Zsx(t,2)+N1-1).*mask_bl;
   
    % 2D transform
    d2_blk = Tfor*blk*Tfor';
    d3_blk(:,:,t) = d2_blk;
end

% 3D Haar transform: full dyadic decomposition of approximation & diff
if isempty(hadper_trans_single_den)==1
    for i=1:N1
        for j=1:N1
            [app,dff] = dwt(d3_blk(i,j,:),'haar');
            %3rd dimension is [approximation,diff]
            d3_blk(i,j,:)=[app,dff];
        end
    end
end

