function inv_mean = attu_mean(mean_est,sigma,nonzero_num)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This function calculate weight for subtracted mean
%
% INPUT ARGUMENT:
% mean_est: mean vector of initial estimate block stack
% sigma: s.d. of noise
% nonzero_num: # of nonzero coefficients in iregular shaped mask
%
% OUTPUT ARGUMENT:
% inv_mean: weights for subtracted mean (refer to Pointwise Shape-adaptive
% DCT denoising, wiener filtering in SA-DCT domain for details
%
%
denom = mean_est.^2 + sigma^2/nonzero_num;

inv_mean = mean_est.^2./denom;
