function Wsx = attu_cof(T_Esx,sigma)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function is to generate wiener shrinkage coefficient matrix correspond to
%%% block stack based on its 3D transform
%
%
%
% INPUT ARGUMENTS:
% 1)T_Esx (3D matrix): 3D transform of block stack
% 2)sigma (integer): noise level
%
%
% OUTPUT ARGUMENT:
% Wsx (3D matrix): wiener shrinkage coefficient matrix
%
%
%
denom = T_Esx.^2+sigma^2;
Wsx = T_Esx.^2./denom;

% if isempty(mask_bl)~=1
%     for i=1:size(Wsx,3)
%         Wsx(:,:,i) = Wsx(:,:,i).*mask_bl;
%     end
% end
