function [nblk,blk_mean] = SA_DCT(blk,dctN,mean)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function operate shape adaptive DCT on shifted iregular shaped
%%%% block. We employ a table method to accelerate DCT. Call
%%%% dct_transMatrix(n) for each column to get transform matrix
%
%
% INPUT ARGUMENT:
% blk: shifted iregular shaped block
% dctN: number of nonzero in column N(dct-N)
%
%
% OUTPUT ARGUMENT:
% blk: DCT transformed block
%
%
nblk = zeros(size(blk));
blk_mean = 1/sum(dctN(1,:))*sum(sum(blk));

if mean==-inf
% calculate mean of the irregular shaped block
   blk = blk - blk_mean;
else
    blk = blk - mean;
end


% columnwise DCT transform
for i=1:size(dctN(1,:))
    f_TranMatrix = transform_Matrix_tab(dctN(1,i))
    nblk(1:dctN(1,i),i) = f_TranMatrix*blk(1:dctN(1,i),i);
end

% rowwise DCT transform
for i=1:size(dctN(2,:))
    f_TranMatrix = transform_Matrix_tab(dctN(2,i));
    nblk(i,1:dctN(2,i)) = blk(i,1:dctN(2,i))*f_TranMatrix;
end
