function wbuff(weight_sx, Esx,mask_bl, N1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function is to aggregate the weighting factor into
%%% weighting buffer, which is a global variable
%
%
%
% INPUT ARGUMENT:
% 1)weight_sx (2D weighting factor window)
% 2)Esx: (x,y) coordinates of matched block in block stack
% 3)mask_bl (binary matrix N1xN1): mask block of object k,
% obj_part=1,otherwise=0
% 4)N1_wiener: block size
%
%
%
% 
global w_buff


N = size(Esx,1);
if isempty(mask_bl)==1
    mask_bl = ones(N1);
end


% aggregate weighting window into global estimation buffer
% if isempty(mask_bl)~=1
%    for t=1:N
%     x = Esx(t,1);
%     y = Esx(t,2);
%     w_buff(x:x+N1-1,y:y+N1-1) = mask_bl.*weight_sx(:,:,t)+w_buff(x:x+N1-1,y:y+N1-1);
%     %wbf = w_buff(x:x+N1-1,y:y+N1-1)
%    end
% else
%     mask_bl = ones(N1);
    for t=1:N
    x = Esx(t,1);
    y = Esx(t,2);
    w_buff(x:x+N1-1,y:y+N1-1) = weight_sx.*mask_bl+w_buff(x:x+N1-1,y:y+N1-1);
    end
% end
