function edge = mark_edge(bound_img, obj)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This fuction detects edges in binary segmented image and mark edge
%%% coordinates
%
%
%
% INPUT ARGUMENTS:
% 1.bound_img (binary matrix MxN): biary segmented image 
% 2.obj (integer): # of objects in bound image
%
% OUTPUT ARGUMENT:
% edge (cell(1,obj)): coordinate of segmentation edge of each object
%
%
%
mk = ones(1,obj); %row index that contains element of certain object:(1,k) corresponds to object k   
edge = cell(1,obj); %detected edge for each segmentation
siz = size(bound_img);
exp = 1;
% detect edge in row iteration
for i=1:siz(1)
    %detect edge in object iteration
    for j=1:obj
        %detect the left boundary
        yf = find(bound_img(i,:)==j,1,'first');
        %if no boundary detected, skip until at least 1 boundary
        %exsits;otherwise mark -1
        s = size(yf);
        if s(2)==0
            switch mk(j)
                case 1
                    continue;
                otherwise
                    yf = -1;
                    continue;
            end
        end
        
        %detect the right boundary
         yl = find(bound_img(i,:)==j,1,'last');
         if (yl==yf)
            yl = -1;
         end

        
        edge{1,j}(mk(j),1)=i;%x coordinate of object j
        edge{1,j}(mk(j),2)=yf;%y coordinate of left boundary of object j
        edge{1,j}(mk(j),3)=yl;%y coordinate of right boundary of object j
        
        mk(j) = mk(j)+1;
    end
end

    
