function inv_s_blk = inv_shift(blk,inv_shift_matrix,N1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function inverse shift iregular shaped block to its original
%%%% position
%
% INPUT ARGUMENT
% blk: shifted iregular shaped block
% inv_shift_matrix: (matrix) each entry indicate the index need to shift to
% N1: block size
%
%
% OUTPUT ARGUMENT:
% inv_s_blk: inverse shifted block
%
%
inv_s_blk = zeros(N1);

for i=1:N1
    for j=1:N1
        if isempty(inv_shift_matrix{i,j})~=1
            inv_s_blk(inv_shift_matrix{i,j}(1),inv_shift_matrix{i,j}(2)) = blk(i,j);
        end
    end
end