function trans_Y = inv_3d_SADCT(trans_Y,hadper_trans_single_den,N1,inv_shift_matrix,dctN)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function inverse DCT transform iregular shaped block and inverse shift to original position. 
%%%% The iregular shaped block is shifted to the top left
%
% INPUT ARGUMENT:
% trans_Y: DCT transform coefficient of iregular shaped block stack
% hadper_trans_single_den:
% N1: block size
% bl_mask: block mask
%
%
% OUTPUT ARGUMENT:
% T_Esx: inverse DCT transformed block stack
%
%
if isempty(hadper_trans_single_den)==1

    l = size(trans_Y);
    if size(l,2)<3
        trans_Y(:,:,1) = trans_Y;
        l(3) = 1;
    end
    %inverse Haar transform in 3rd
   if l(3)>1
      for i=1:size(dctN(2,:),2)
          for j=1:dctN(2,i)
        % size(trans_Y)
             trans_Y(i,j,:) = idwt(trans_Y(i,j,1:l(3)/2),trans_Y(i,j,(l(3)/2+1):l(3)),'haar');         
          end
    %end
      end
   end
end

% 2D inverse transform
% rowwise inverse DCT transform
for t=1:size(trans_Y,3)
    blk = trans_Y(:,:,t);
    
    for i=1:size(dctN(2,:))
        inv_TranMatrix = inv_transform_Matrix_tab(dctN(2,i));
        blk(i,1:dctN(2,i)) = blk(i,1:dctN(2,i))*inv_TranMatrix;
    end

  % columnwise inverse DCT transform
    for i=1:size(dctN(1,:))
        inv_TranMatrix = inv_transform_Matrix_tab(dctN(1,i));
        blk(1:dctN(1,i),i) = inv_TranMatrix*blk(1:dctN(1,i),i);
    end
  % inverse shift block  
  blk = inv_shift(blk,inv_shift_matrix,N1)
  trans_Y(:,:,t),
  trans_Y(:,:,t) = blk;
end
  
  


