function [Ysx,wxr] = hard_thr(Zsx, N1, lambda_thr3D, Tfor, Tinv, hadper_trans_single_den,nois_img,sigma,mask_bl)%)orig_img)%)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function get initial block estimate with HT filter in BM3D, and
%%%% block weighting factor to aggregate.
%
%
%
% INPUT ARGUMENT:
% Zsx: [(x,y),...] block coordinates of block stack
% N1: block size
% lambda_thr3D: parameter in 3D threshold
% nois_img: noisy image
% Tfor: 2D forward transform matrix
% Tinv: 2D inverse transform matrix
% hadper_trans_single_den: indicate if Haar is used in 3rd transform
%
%
% OUTPUT ARGUMENTS:
% Ysx: initial estimate of block stack
% wxr: weighting factor of the block stack
%
%
if (exist('mask_bl')~=1||isempty(mask_bl)==1)
    mask_bl = ones(N1);
end

% 3D block stack transform
T_Zsx = d3_thr_trans(Zsx,N1,nois_img,Tfor,hadper_trans_single_den,mask_bl);
% % estimate local block stack variance 
% sigma = d3_var_est(Zsx,nois_img,orig_img,N1);
% hard threshold filter
HT_T_Zsx= ht(T_Zsx,lambda_thr3D,sigma);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
non0 = size(find(HT_T_Zsx~=0),1);
if non0>=1
    wxr = 1/(sigma^2*non0);
else
    wxr = 1;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Edge Sharpening 
% weighting factor
% alpha = 1.5;
% weight_Zsx = ((1-1/alpha)^2*abs(HT_T_Zsx(1,1,1))^(-2/alpha).*abs(HT_T_Zsx).^(2/alpha)+1/(alpha^2).*(abs(HT_T_Zsx).^(2/alpha-2)).*(abs(HT_T_Zsx(1,1,1))^(2-2/alpha)))*sigma^2;
% w_mask = find(isinf(weight_Zsx));
% for i=1:size(w_mask,1)
%     weight_Zsx(w_mask(i))=0;
% end
% v = sum(sum(sum(weight_Zsx)))-weight_Zsx(1,1,1)+sigma^2;
% wxr = 1/v;
% 
% %edge sharpening in 3D transform domain
% if HT_T_Zsx(1,1,1)~=0
%     HT_T_Zsx =(HT_T_Zsx./abs(HT_T_Zsx)).*HT_T_Zsx(1,1,1).*(abs(HT_T_Zsx./HT_T_Zsx(1,1,1)).^(1/alpha));
%     c_mask = find(isnan(HT_T_Zsx));
%     for i=1:size(c_mask,1)
%         HT_T_Zsx(c_mask(i))=0;
%     end
% end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% inverse 3D block stack transform 
Ysx = inv_3d_trans(HT_T_Zsx, Tinv, hadper_trans_single_den, N1,mask_bl);

% force to 0 if inverse transform cof<0
les0 = find(Ysx<0);
for i=1:size(les0,1)
    Ysx(les0(i))=0;
end




