function sigma = d3_var_est(Zsx,nois_img,orig_img,N1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function estimate variance in 3D block stack. The variance is
%%%% used for adaptive threshold in HT filter.
%
%
% INPUT ARGUMENT:
% Zsx: [(x,y)...] coordinates of block stack
%
%
% OUTPUT ARGUMENT:
% sigma: estimated std. deviation
%
%
%
id = 1;
for t=1:size(Zsx,1)
    n_bl = nois_img(Zsx(t,1):Zsx(t,1)+N1-1,Zsx(t,2):Zsx(t,2)+N1-1);
    o_bl = orig_img(Zsx(t,1):Zsx(t,1)+N1-1,Zsx(t,2):Zsx(t,2)+N1-1);
    err_blk(:,:,id) = n_bl - o_bl;
end

sigma = std(err_blk(:));

    