function [d3_blk,n_mean] = d3_SADCT(Esx, img, hadper_trans_single_den, N1, bl_mask, shift_matrix, dctN, mean)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function performs shape-adaptive DCT to iregular shaped segment
%%%% in N1_wiener size window
%
%
% INPUT ARGUMENT:
% Esx: (x,y) coordinates of block stack
% img (matrix MxN): image
% hadper_trans_single_den: indicator if Haar is used
% N1: block size
% bl_mask: segment mask to mark the iregular shape
%
%
% OUTPUT ARGUMENT:
% 3d_blk (3D matrix): 3D transform of block stack, same size with Esx
% dctN: length in column and row of the shifted block

if exist('mean')~=1
    mean = zeros(1,size(Esx,1))-inf;
end

for t=1:size(Esx,1)
    blk = img(Esx(t,1):Esx(t,1)+N1-1,Esx(t,2):Esx(t,2)+N1-1).*bl_mask;
    % shift to top left of block, check columnwise
    blk = bl_shift(blk,shift_matrix,N1);    
    % shape adaptive DCT
    [blk,blk_mean] = SA_DCT(blk,dctN,mean(t));
    %d2_blk = inv_shift(blk,bl_mask);
    d3_blk(:,:,t) = blk;
    n_mean(t) = blk_mean;
end
if t==1
    return;
else
  % 3D Haar transform: full dyadic decomposition of approximation & diff
  if isempty(hadper_trans_single_den)==1
    for i=1:size(dctN(2,:),2)
        for j=1:dctN(2,i)
            [app,dff] = dwt(d3_blk(i,j,:),'haar');
            %3rd dimension is [approximation,diff]
            d3_blk(i,j,:)=[app,dff];
        end
    end
  end
end