function y_est = bound_wiener(bound_img, obj, HT_img, nois_img, N1_wiener, Nstep_wiener, N2_wiener, Ns_wiener,...
    sigma, tau_match_wiener, TforW, TinvW, hadper_trans_single_den, Wwin2D_wiener)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% This is corn function in Adapative Shaped BM3D. In segmented image
%%%%% (marked by edge), pad the irregular shaped blocks (close to boundary) to rectangular
%%%%% shape with the nearest areas from the same segmentation, and do block
%%%%% matching, 3D & inverse 3D to get the wiener estimate. Leave out the
%%%%% padding areas, and aggregate local estimates by weighting.

%
%
%
% INPUT ARGUMENTS:
% 1.bound_img (binary matrix MxN): perfectly segmented binary map of the noisy image, used in wiener filtering. 
% 0 = background; 1 = 1st object; 2 = 2nd object...
% 2.edge (matrix): edge coordinates (x,y) of each segmented are
% 3.HT_img (matrx MxN): HT filtered image, as initial estimate in Wiener Filter
% extension
%
% 4.sigma (double): standard deviation of noise
% 5.N1_wiener (integer): block size in BM
% 6.Nstep_wiener (integer): step size of sliding window (both vertical and
% horizontal)
% 7.N2_wiener (integer): upbound of match block
% 8.Ns_wiener: search range centered at current block
% 9.sigma: normalized standard deviation of noise
% 10.tau_match_wiener (double): threshold in block matching
% 11.TforW (matrix MxN): forward transform
% 12.TinvW (matrix MxN): inverse transform
% 13.hadper_trans_single_den: 3D transform index (haar or not)
% 14.Wwin2D_wiener: Kaiser window 
%
%
% OUTPUT ARGUMENT:
% y_est (matrix MxN): final estimation via AS BM3D
%
%
% 
global e_buff 
global w_buff

[m,n] = size(HT_img);
e_buff = zeros(m,n);
w_buff = zeros(m,n);
num = 0;
% sliding window over overall image with Nstep_wiener step size
for i=0:floor((m-(N1_wiener))/Nstep_wiener)
    for j=0:floor((n-(N1_wiener))/Nstep_wiener)
        % coordinate of current block
        x = Nstep_wiener*i +1;
        y = Nstep_wiener*j +1;
        
% For each current block
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Step 1: detect # objects in block
[mask,obj_indx] = bl_dect(x,y,N1_wiener,bound_img,obj);
obj_num = size(obj_indx,2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Step 2: block matching for each object part
k = 1;
t = 1;
% mask=cell(1,1);
while k<=obj_num
    % Match block stack Esx {(x,y),N1xN1 match_block}
    if obj_num==1 % block does not cross boundary
    Esx = rect_blm(x,y,Ns_wiener,N2_wiener,N1_wiener,tau_match_wiener,m,n,HT_img,bound_img);
    else % cross boundary   
    t=obj_indx(k);
    Esx = irg_blm(x,y,Ns_wiener,N2_wiener,N1_wiener,mask{t,1},k,tau_match_wiener,m,n,HT_img); %Esx={(x1,y1),(x2,y2)...(xk,yk)},(xk,yk) is block stack for object k   
    num = num+1;
    end
    
    % 3D transform of block stack,2D+1D(haar)
%     if isempty(mask{t,1})~=1
%        [dctN, shift_matrix, inv_shift_matrix] = shift(mask{t,1},N1_wiener); 
%        % SA-DCT for noisy image and return mean
%        [T_Zsx,mean_zsx] = d3_SADCT(Esx,nois_img,hadper_trans_single_den, N1_wiener, mask{t,1}, shift_matrix, dctN);
%        % substrat mean of noise before SA-DCT in initial estimate image
%        [T_Esx,mean_esx] = d3_SADCT(Esx, HT_img, hadper_trans_single_den, N1_wiener, mask{t,1}, shift_matrix, dctN, mean_zsx);
%        
%     else
       T_Esx = d3_trans(Esx,HT_img,TforW,hadper_trans_single_den,N1_wiener,mask{t,1});
       T_Zsx = d3_trans(Esx,nois_img,TforW,hadper_trans_single_den,N1_wiener,mask{t,1});
%     end
    % Attenuate coefficients for wiener filter
    Wsx = attu_cof(T_Esx,sigma);
    
    % derive noisy block from initial estimation
    % Zsx = noisy_bl(Esx,mask{k,1},nois_img);
    % estimate of block stack after forward & inverse 3D transform
    
    T_Zsx = Wsx.*T_Zsx;
    
%     if isempty(mask{t,1})~=1
%         nonzero_num = size(find(mask{t,1}>0),1);
%         inv_mean = attu_mean(mean_esx,sigma,nonzero_num);
%     end

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Edge Sharpening 
% weighting factor
% alpha = 1.5;
% weight_Zsx = ((1-1/alpha)^2*abs(T_Zsx(1,1,1))^(-2/alpha).*abs(T_Zsx).^(2/alpha)+1/(alpha^2).*(abs(T_Zsx).^(2/alpha-2)).*(abs(T_Zsx(1,1,1))^(2-2/alpha)))*sigma^2;
% w_mask = find(isinf(weight_Zsx));
% for h=1:size(w_mask,1)
%     weight_Zsx(w_mask(h))=0;
% end
% 
% %edge sharpening in 3D transform domain
% if T_Zsx(1,1,1)~=0
%     T_Zsx =(T_Esx./abs(T_Esx)).*T_Zsx(1,1,1).*(abs(T_Zsx./T_Zsx(1,1,1)).^(1/alpha));
%     c_mask = find(isnan(T_Zsx));
%     for h=1:size(c_mask,1)
%         T_Zsx(c_mask(h))=0;
%     end
% end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     if isempty(mask{t,1})~=1
%        Ysx = inv_3d_SADCT(T_Zsx,hadper_trans_single_den,N1_wiener,inv_shift_matrix,dctN);
%        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        %%% local wiener filter estimate = inverse + scaled_subtracted_mean
%        for m=1:size(Ysx,3)
%            Ysx(:,:,m) = (Ysx(:,:,m)+inv_mean(m)*mean_zsx(m)).*mask{t,1};
%        end
%        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        % weight in pixelwise in SA-DCT
%        weight_sx = sa_bl_weight(Wsx,sigma,inv_mean,nonzero_num,Wwin2D_wiener);
%     else
       Ysx = inv_3d_trans(T_Zsx,TinvW,hadper_trans_single_den,N1_wiener,mask{t,1});
%        weight in pixelwise
       weight_sx = bl_weight(Wsx,sigma).*Wwin2D_wiener;
%     end

    les0 = find(Ysx<0);
    for l=1:size(les0,1)
        Ysx(les0(l))=0;
    end
    

    % put estimation pixelwise in ebuff, and weight in wbuff
    ebuff(Ysx,weight_sx,Esx,N1_wiener);
    wbuff(weight_sx,Esx,mask{t,1},N1_wiener);
    
    k = k+1;
end
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Step 3: aggregate all estimates
y_est = e_buff./w_buff;
padid = find(isnan(y_est));
for t=1:size(padid,1)
    y_est(padid(t))=HT_img(padid(t));
end





