function y_hat = bm3d_BD_HT(nois_img,bound_img, obj, hadper_trans_single_den, Nstep, N1, N2, lambda_thr2D,...
	lambda_thr3D, tau_match, Ns, sigma, Tfor, Tinv, Wwin2D)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This is corn function in Adapative Shaped BM3D in HT filtering stage. In segmented image
%%%%% (marked by edge), when edge is detected in a block, do block matching for each partition respectively, 
%%%%% group, 3D filtering and aggregate local estimates by weighting.

%
%
% INPUT ARGUMENTS:
% nois_img: noisy image
% bound_img: perfectly segmented binary map of the noisy image, used in wiener filtering. 
% 0 = background; 1 = 1st object; 2 = 2nd object...
% obj: # objects in image
% hadper_trans_single_den: indicate if Haar is used in 3rd transform
% Nstep: slide step
% N1: block size
% N2: maximum # block in block stack
% lambda_thr2D,lambda_thr3D: parameters in HT filtering
% tau_match: threshold in HT filtering
% Ns: search range
% sigma: std deviation of noise
% Tfor: forward transform matrix
% Tinv: inverse transform matrix
% Win2D: kaiser window


global e_buff 
global w_buff

[m,n] = size(nois_img);
e_buff = zeros(m,n);
w_buff = zeros(m,n);

% sliding window over overall image with Nstep_wiener step size
for i=0:floor((m-(N1-1))/Nstep)
    for j=0:floor((n-(N1-1))/Nstep)
        % coordinate of current block
        x = Nstep*i +1;
        y = Nstep*j +1;
        
% For each current block
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Step 1: detect # objects in block
[mask,obj_indx] = bl_dect(x,y,N1,bound_img,obj);
obj_num = size(obj_indx,2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Step 2: block matching for each object part
k = 1;
t = 1;
%mask=cell(1,1);
while k<=obj_num
    % Match block stack Esx {(x,y),N1xN1 match_block}
    if obj_num==1 % block does not cross boundary
    Zsx = bl_m(x,y,N1,N2,Ns,lambda_thr2D,tau_match,bound_img,nois_img,Tfor,sigma);
    else % cross boundary   
    t=obj_indx(k);
    Zsx = irg_blm_ht(x,y,Ns,N2,N1,mask{t,1},k,lambda_thr2D,tau_match,m,n,nois_img,Tfor,sigma); %Zsx={(x1,y1),(x2,y2)...(xk,yk)},(xk,yk) is block stack for object k   
    end
    
    % hard threshold filter to get block initial estimate & weight
    [Ysx,wxr] = hard_thr(Zsx,N1,lambda_thr3D,Tfor,Tinv,hadper_trans_single_den,nois_img,sigma,mask{t,1});%orig_img;
    weight_sx = wxr.*Wwin2D;
   

    les0 = find(Ysx<0);
    for l=1:size(les0,1)
        Ysx(les0(l))=0;
    end
    
    ebuff(Ysx,weight_sx,Zsx,N1);
    wbuff(weight_sx,Zsx,mask{t,1},N1);
    
    k = k+1;
end
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Step 3: aggregate all estimates
y_hat = e_buff./w_buff;
padid = find(isnan(y_hat));
for t=1:size(padid,1)
    y_hat(padid(t))=nois_img(padid(t));
end

