function Zsx = bl_m(x, y, N1, N2, Ns, lambda_thr2D, tau_match, bound_img,nois_img, Tfor, sigma)%orig_img)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This function is to do block matching with HT filter in BM3D, the
%%%% algorithm is based on HT-BM3D, with modification in finding an
%%%% adaptive threshold by finding local variance.

%
%
%
% INPUT ARGUMENT:
% x,y: coordinates of current block
% N1: block size
% N2: maximum cardinality of block stack
% lambda_thr2D: parameter in 2D threshold
% tau_match: block matching threshold
% nois_img: noisy image
% orig_img: original image (estimate local variance)
% Tfor: 2D forward transform matrix


%
%
% OUTPUT ARGUMENT:
% Zsx: [(x,y),...] block coordinate in block stack
[m,n] = size(nois_img);

% Step 1: bound search range in NsxNs
x1 = x-(Ns-1)/2;
x2 = x+(Ns-1)/2;

y1 = y- (Ns-1)/2;
y2 = y+ (Ns-1)/2;

%(xt,yt) and (xb,yb) is top-left and bottom right of search range
if x1<=0
    xt = 1;
else
    xt = x1;
end

if x2>m
    xb = m;
else
    xb = x2;
end

if y1<=0
    yt = 1;
else
    yt = y1;
end

if y2>n
    yb = n;
else
    yb = y2;
end

% estimate local variance (parameter sigma) 
%sigma = d2_var_est(xt,yt,xb,yb,nois_img,orig_img);

Zsx(1,1) = x;
Zsx(1,2) = y;
Zsx(1,3) = 0;

id = 1;
curr_bl = nois_img(x:x+N1-1,y:y+N1-1);
d2_bl = Tfor*curr_bl*Tfor';
d0 = ht(d2_bl,lambda_thr2D,sigma);

for i=0:xb-(N1-1)-xt
    for j=0:yb-(N1-1)-yt
        if (xt+i==x)&&(yt+j==y)
            continue;
        else
            bound_bl = bound_img(xt+i:xt+i+N1-1,yt+j:yt+j+N1-1);
            if min(size(find(bound_bl~=bound_img(x,y),1)))>0
                continue;
            else
                s_bl = nois_img(xt+i:xt+i+N1-1,yt+j:yt+j+N1-1);
                d2_sbl = Tfor*s_bl*Tfor';
                ds = ht(d2_sbl,lambda_thr2D,sigma);
                err = mean((d0(:)-ds(:)).^2);
        
                if err<tau_match
                   id = id+1;
                   Zsx(id,1)=xt+i;
                   Zsx(id,2)=yt+j;
                   Zsx(id,3)=err;
                end
             end
         end
      end
        
end


%reorder so that error ascends
Zsx = sortrows(Zsx,3);

if id>N2
    %select the first N2 of smallest error  
    Zsx = Zsx(1:N2,1:2);
    % force 3rd dimension is a power of 2 for 1D haar transform
else if id~=2^(floor(log2(id)))
        id = 2^(floor(log2(id)));
        Zsx = Zsx(1:id,1:2);
    end
end

