function [psnr,psnr_264] = V_AS_BM3D(filename,...%codfilename,...
                                     seq_size, frame_num, mask_seq, center_seq) %sigma)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% V_AS_BM3D is a function to process video sequence frame by frame via
% Adaptive Shaped BM3D. For each frame, it works in this way:1.add white noise to noise free video sequence; 
% 2.Denoise the frame via Adaptive Shaped BM3D; 3.Caculate PSNR of the processed frame.
%
%
%  
%  INPUT ARGUMENTS:
%  
%  1)filename: original video sequence
%  2)seq_size:     [M,N] vector, M frame width, N frame height
%  3)frame_num:    # frame need to be processed
%  4)mask_seq (cell matrix of sequence size): binary map of frames
%  5)center_seq (matrix of sequence size): size(center_seq)/2 => # objects
%  in each frame
%
%  INPUT ARGUMENTS (Optional):
%  sigma: variance of noise frame if available(often not available)

%  OUTPUT ARGUMENT
%  PSNR: frame_numX1 matric,PSNR list of each frame after AS_BM3D filter


fid1 = fopen(filename, 'r') % original file
%fid2 = fopen(codfilename,'r')

% use default sigma to produce noisy image
if (exist('sigma') ~= 1),
    sigma = 50;
end
k=1;
for i=1:frame_num
    %Y matrix formation
    % original file read
    fseek(fid1,(i-1)*1.5*seq_size(1)*seq_size(2),'bof');
    frame_Y_orig=fread(fid1,seq_size(1)*seq_size(2));
    frame_Y_orig=reshape(frame_Y_orig,seq_size(1),seq_size(2))';

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% test BM3D in video after deblocking
%     fseek(fid2,(i-1)*1.5*seq_size(1)*seq_size(2),'bof');
%     frame_Y=fread(fid2,seq_size(1)*seq_size(2));
%     frame_Y=reshape(frame_Y,seq_size(1),seq_size(2))';
%     
%     if (exist('sigma') ~= 1),
%     sigma = sigma_est(frame_Y_orig,frame_Y,1);
%     end
%     frame_Y = double(frame_Y)/255;
%     %scale the intensity to [0,1]
%     frame_Y_orig = double(frame_Y_orig)/255;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    randn('seed', 0);                          %% generate seed
    frame_Y_orig = double(frame_Y_orig)/255;
    nois_img = frame_Y_orig + (sigma/255)*randn(size(frame_Y_orig)); %% create a noisy image

%     figure;
%     imshow(frame_Y_orig.*mask_seq{i,1});
%     figure;
%     imshow(frame_Y_orig);
%     figure;
%     imshow(frame_Y);

    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% detect # objects in frame
    %%%%%%% If all center=0, no object, AS wiener filter is wiener filter
    [m,n] = size(center_seq);
    obj = n/2;
    if max(size(find(center_seq(i,:)==0)))==n %all center in frame is 0 
        obj = 0;
    else 
        for j=1:n/2
            if (center_seq(i,2*j-1)==0 && center_seq(i,2*j)==0) %substract 1 object if a center pair is 0
                obj = obj-1;
            end
        end
    end

% AS_BM3D 
[PSNR,PSNR_noise,y_est] = AS_BM3D(nois_img, frame_Y_orig, mask_seq{i,1}, obj, sigma);
figure;
imshow(y_est);
psnr_264(k)=PSNR_noise;
psnr(k)=PSNR;
k=k+1;

% figure; imshow(frame_Y_264);title(sprintf('inloop only, frame %d, PSNR = %ddB',i,PSNR_264_frame));
% figure; imshow(frame_Y_est);title(sprintf('inloop+BM3D, frame %d, PSNR = %ddB',i,PSNR_frame));

% write the BM3D frame to video file
%   fwrite(fid3, frame_Y_orig');
%   fwrite(fid3, frame_Cb);
%   fwrite(fid3, frame_Cr);



end

fclose(fid1);

%fclose(fid2);