function y_est = BD_wiener(bound_img, obj, HT_img, nois_img, N1_wiener, Nstep_wiener, N2_wiener,...
    Ns_wiener, sigma, tau_match_wiener, TforW, TinvW, hadper_trans_single_den, Wwin2D_wiener) 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% This function detects edges and applies Adaptive Shaped wiener filter to get the estimate.
%%% in Bound_BM3D algorithm. In Wiener Filter Extension, it does Block Matching
%%% in each segmentation, crossing boundary is prohibitted. For irregular
%%% shaped near boundary areas, first pad them into block with its closest
%%% neighbours and operate BM & 3D to get the estimation. 
%
%
%
%
% INPUT ARGUMENTS:
% 1.bound_img (binary matrix MxN): perfectly segmented binary image. 0 = background; 1 = 1st
% object; 2 = 2nd object...
%
% 2.obj (integer): # of objects in bound_img
% 3.HT_img (matrx MxN): HT filtered image, as initial estimate in Wiener Filter
% extension
% 4.nois_img (matrix MxN): noisy image

% 5.N1_wiener (integer): block size in BM
% 6.Nstep_wiener (integer): step size of sliding window (both vertical and
% horizontal)
% 7.N2_wiener (integer): upbound of match block
% 8.Ns_wiener: search range centered at current block
% 9.sigma: normalized standard deviation of noise
% 10.tau_match_wiener (double): threshold in block matching
% 11.TforW (matrix MxN): 2D forward transform
% 12.TinvW (matrix MxN): 2D inverse transform
% 13.hadper_trans_single_den: 3D transform index (haar or not)
% 14.Wwin2D_wiener: Kaiser window 

% OUTPUT ARGUMENTS:
% y_est (matrix MxN): output of bound BM3D in wiener filter extension
%
%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% mark edge for each segmentation in bound_img
%edge = mark_edge(bound_img, obj);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%bound BM3D in wiener filter extension
 y_est = bound_wiener(bound_img, obj, HT_img, nois_img, N1_wiener, Nstep_wiener, N2_wiener, Ns_wiener, sigma, tau_match_wiener,...
    single(TforW), single(TinvW)', hadper_trans_single_den, Wwin2D_wiener);

y_est = double(y_est);

 